/*
   This program writes 6,000,000 randomly chosen bytes
   to an output file. The bytes are written in bunches,
   which are called "messages" in this program. If you
   write all 6,000,000 bytes in one bunch, the program
   runs as fast as possible. If you write the 6,000,000
   bytes in 6,000,000 messages of one byte each, this
   program runs as slow as possible, The difference in
   performance has to do with how the operating system's
   undelying buffers are being used. It does not seem
   that the Java PrintStream object tied to the file
   has its own buffering.

   Be sure to try LENGTH_OF_MESSAGE with values of 1, 10,
   100, 1,000, 10,000, etc.
*/
import java.io.*;

public class Ex6_UsingAnOutputBuffer
{
   public static void main(String[] args) throws IOException
   {
      // Set System.out to be a file.
      System.setOut( new PrintStream( new FileOutputStream( "test.txt" ) ) );

      final int LENGTH_OF_MESSAGE = 1;  // Be sure to try different values.
      System.err.println("Using LENGTH_OF_MESSAGE = " + LENGTH_OF_MESSAGE);

      java.util.Random rand = new java.util.Random();

      long startTime = System.currentTimeMillis(); // "start" the timer

      // Write 6,000,000 bytes to output.
      for (int counter = 1; counter <= 6000000/LENGTH_OF_MESSAGE; counter++)
      {
         // prepare a "message"
         char mesg[] = new char[LENGTH_OF_MESSAGE];
         for(int i = 0; i < LENGTH_OF_MESSAGE; i++)
         {
            mesg[i] = (char)( rand.nextInt(95) + 32 );
         }
         System.out.print(mesg);
         //System.out.flush();     // try commenting this out
      }
      System.out.close();

      long endTime = System.currentTimeMillis();  // "stop" the "timer

      System.err.println("Total execution time (wct): " + (endTime - startTime) );
   }
}